<?php
session_start();

// Verificar si el usuario está logueado
if (!isset($_SESSION['usuario_logueado']) || $_SESSION['usuario_logueado'] !== true) {
    header('Location: login_register.html');
    exit();
}

// Incluir conexión a base de datos
require_once 'conexion.php';

try {
    // Obtener todas las plazas
    $stmt = $conexion->prepare("SELECT * FROM plazas ORDER BY posicion_y, posicion_x");
    $stmt->execute();
    $resultado = $stmt->get_result();
    $plazas = $resultado->fetch_all(MYSQLI_ASSOC);
} catch (PDOException $e) {
    die("Error al obtener plazas: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mapa de Parking - Viewnext</title>
    <style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }
    
    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background: #212121;
        min-height: 100vh;
        color: #fff;
    }
    
    .container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 20px;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        gap: 20px;
    }
    
    /* Header*/
    .header {
        background: transparent;
        padding: 20px;
        border-radius: 0;
        box-shadow: none;
        margin-bottom: 20px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        width: 100%;
        max-width: 1000px;
        border: none;
    }
    
    .header h1 {
        color: #fff;
        font-size: 1.8rem;
        font-weight: 600;
    }
    
    .user-info {
        display: flex;
        align-items: center;
        gap: 15px;
        color: #fff;
    }
    
   .logout-container {
      display: flex;
      position: relative;
    }
    
    .logout-btn {
      cursor: pointer;
      background: none;
      border: none;
      border-radius: 8px;
      padding: 0.4em 1em;
      font-size: 16px;
      font-weight: 600;
      color: #ffffff;
      transition: all 0.3s ease;
      text-decoration: none;
      position: relative;
      z-index: 1;
    }
    
    .logout-btn:hover {
      letter-spacing: 2px;
    }
    
    .logout-container .arrow {
      fill: #ffffff;
      position: absolute;
      pointer-events: none;
      width: 16px;
      left: 0;
      top: 50%;
      transform: translateY(-50%);
      transition: all 0.3s cubic-bezier(0.645, 0.045, 0.355, 1);
      z-index: 0;
    }
    
    .logout-container .arrow svg {
      transform: rotate(180deg);
    }
    
    .logout-container .second,
    .logout-container .third {
      opacity: 0;
    }
    
    .logout-container .logout-btn:hover ~ .second {
      opacity: 0.66;
      left: -20px;
      transition-delay: 50ms;
    }
    
    .logout-container .logout-btn:hover ~ .third {
      opacity: 0.33;
      left: -40px;
      transition-delay: 100ms;
    }
    
    /* Filtros */
    .filters {
        background: #212121;
        padding: 20px;
        border-radius: 15px;
        box-shadow: inset 2px 2px 10px rgba(0,0,0,1),
                    inset -1px -1px 5px rgba(255, 255, 255, 0.6);
        margin-bottom: 20px;
        display: flex;
        gap: 20px;
        justify-content: center;
        align-items: center;
        flex-wrap: wrap;
        width: 100%;
        max-width: 1000px;
    }
    
    .filter-group {
        display: flex;
        flex-direction: column;
        gap: 10px;
    }
    
    .filter-group label {
        font-weight: 600;
        color: #fff;
        font-size: 0.9rem;
    }
    
    .filter-select {
        width: 200px;
        min-height: 45px;
        color: #fff;
        outline: none;
        transition: 0.35s;
        padding: 0px 15px;
        background-color: #212121;
        border-radius: 6px;
        border: 2px solid #212121;
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(255, 255, 255, 0.6);
        font-size: 1rem;
    }
    
    .filter-select:focus {
        transform: scale(1.05);
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(255, 255, 255, 0.6),
                    inset 2px 2px 10px rgba(0,0,0,1),
                    inset -1px -1px 5px rgba(255, 255, 255, 0.6);
    }
    
    .filter-select option {
        background-color: #212121;
        color: #fff;
    }
    
    /* Leyenda */
    .leyenda {
        background: #212121;
        padding: 20px;
        border-radius: 15px;
        box-shadow: inset 2px 2px 10px rgba(0,0,0,1),
                    inset -1px -1px 5px rgba(255, 255, 255, 0.6);
        margin-bottom: 20px;
        display: flex;
        gap: 20px;
        justify-content: center;
        flex-wrap: wrap;
        width: 100%;
        max-width: 1000px;
    }
    
    .leyenda-item {
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 0.9rem;
        font-weight: 500;
        color: #fff;
    }
    
    .plaza-example {
        width: 25px;
        height: 25px;
        border-radius: 4px;
        border: 2px solid #333;
    }
    
    /* Mapa del parking - Estilo Card */
    .parking-map {
        width: auto;
        height: auto;
        min-width: 600px;
        min-height: 400px;
        border-radius: 30px;
        background: #212121;
        box-shadow: 15px 15px 30px rgb(25, 25, 25),
                    -15px -15px 30px rgb(60, 60, 60);
        padding: 20px;
        margin-bottom: 30px;
        position: relative;
        overflow-x: auto;
        max-width: 1000px;
    }
    
    .zona-label {
        position: absolute;
        font-weight: bold;
        font-size: 0.8rem;
        color: #fff;
        writing-mode: vertical-rl;
        text-orientation: mixed;
    }
    
    .abanca-label {
        left: 5px;
        top: 50px;
        color: #e91e63;
    }
    
    .motos-label {
        left: 5px;
        bottom: 50px;
        color: #4caf50;
    }
    
    .parking-grid {
        display: flex;
        flex-direction: column;
        gap: 5px;
        margin: 20px;
        min-width: 600px;
    }
    
    .fila-parking {
        display: flex;
        gap: 5px;
        justify-content: center;
    }
    
    /* Estilos de plazas */
    .plaza {
        width: 80px;
        height: 40px;
        border: 2px solid #333;
        border-radius: 6px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
        font-size: 0.8rem;
        position: relative;
        transition: all 0.3s ease;
        cursor: default;
        background-color: #212121;
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(255, 255, 255, 0.6);
    }
    
    .plaza-numero {
        color: #fff;
        font-size: 0.75rem;
        font-weight: bold;
    }
    
    .plaza-vacia {
        width: 80px;
        height: 40px;
        margin: 2px;
    }
    
    /* Estados de las plazas */
    .disponible {
        background: linear-gradient(145deg, #4caf50, #2e7d32);
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(76, 175, 80, 0.3);
    }
    
    .ocupada {
        background: linear-gradient(145deg, #f44336, #c62828);
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(244, 67, 54, 0.3);
    }
    
    .no-reservable {
        background: linear-gradient(145deg, #9e9e9e, #616161);
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(158, 158, 158, 0.3);
    }
    
    /* Tipos de plazas */
    .abanca.disponible {
        background: linear-gradient(145deg, #4caf50, #2e7d32);
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(76, 175, 80, 0.3);
    }
    
    .abanca.ocupada {
        background: linear-gradient(145deg, #2e7d32, #1b5e20);
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(46, 125, 50, 0.3);
    }
    
    .pool.disponible {
        background: linear-gradient(145deg, #4caf50, #2e7d32);
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(76, 175, 80, 0.3);
    }
    
    .pool.ocupada {
        background: linear-gradient(145deg, #2e7d32, #1b5e20);
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(46, 125, 50, 0.3);
    }
    
    .motos {
        background: linear-gradient(145deg, #9e9e9e, #616161);
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(96, 125, 139, 0.3);
    }
    
    .visitas {
        background: linear-gradient(145deg, #9e9e9e, #616161);
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(96, 125, 139, 0.3);
    }
    
    .gerente {
        background: linear-gradient(145deg, #9e9e9e, #616161);
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1x 1px 10px rgba(96, 125, 139, 0.3);
    }
    
    .director {
        background: linear-gradient(145deg, #ff9800, #f57c00);
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(255, 152, 0, 0.3);
    }
    
    /* Efectos hover para plazas clickeables */
    .clickable:hover {
        transform: scale(1.1);
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(255, 255, 255, 0.6),
                    inset 2px 2px 10px rgba(0,0,0,1),
                    inset -1px -1px 5px rgba(255, 255, 255, 0.6);
        cursor: pointer;
        z-index: 10;
    }
    
    .clickable.disponible:hover {
        background: linear-gradient(145deg, #66bb6a, #4caf50);
    }
    
    .clickable.abanca.disponible:hover {
        background: linear-gradient(145deg, #ec407a, #e91e63);
    }
    
    /* Elementos decorativos del mapa */
    .elementos-mapa {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        pointer-events: none;
    }
    
    .escalera {
        position: absolute;
        right: 50px;
        bottom: 50px;
        background: #212121;
        border: 2px solid #333;
        border-radius: 10px;
        padding: 10px;
        text-align: center;
        font-size: 0.7rem;
        color: #fff;
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(255, 255, 255, 0.6);
    }
    
    .escalera span {
        font-size: 2rem;
        display: block;
        margin-bottom: 5px;
    }
    
    .plantas {
        position: absolute;
        font-size: 2rem;
        color: #4caf50;
    }
    
    .plantas {
        right: 100px;
        top: 100px;
    }
    
    .plantas-2 {
        right: 100px;
        top: 200px;
    }
    
    .plantas-3 {
        right: 100px;
        top: 300px;
    }
    
    /* Mis Reservas */
    .mis-reservas {
        background: #212121;
        padding: 20px;
        border-radius: 15px;
        box-shadow: inset 2px 2px 10px rgba(0,0,0,1),
                    inset -1px -1px 5px rgba(255, 255, 255, 0.6);
        margin-bottom: 20px;
        width: 100%;
        max-width: 1000px;
    }
    
    .mis-reservas h3 {
        color: #fff;
        margin-bottom: 15px;
        font-weight: 600;
    }
    
    .reserva-item {
        background: #212121;
        padding: 15px;
        border-radius: 10px;
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(255, 255, 255, 0.6);
        margin-bottom: 10px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 10px;
    }
    
    .reserva-info {
        flex: 1;
        color: #fff;
    }
    
    .reserva-acciones {
        display: flex;
        gap: 10px;
    }
    
    button {
      padding: 12px 25px;
        cursor: pointer;
        background-color: #212121;
        border-radius: 6px;
        border: 2px solid #212121;
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(255, 255, 255, 0.6);
        color: #fff;
        font-size: 1rem;
        font-weight: bold;
        transition: 0.35s;
    }
    
    button:hover {
      box-shadow: var(--hover-shadows);
    }

    button:active {
      box-shadow: var(--hover-shadows), var(--accent) 0px 0px 30px 5px;
      background-color: var(--accent);
      transform: scale(0.95);
    }
    
    /* Modal */
    .modal {
        display: none;
        position: fixed;
        z-index: 1000;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0,0,0,0.8);
        animation: fadeIn 0.3s;
    }
    
    .modal-content {
        background: #212121;
        margin: 5% auto;
        padding: 30px;
        border-radius: 15px;
        width: 90%;
        max-width: 500px;
        box-shadow: inset 2px 2px 10px rgba(0,0,0,1),
                    inset -1px -1px 5px rgba(255, 255, 255, 0.6);
        animation: slideIn 0.3s;
        color: #fff;
    }
    
    .close {
        color: #999;
        float: right;
        font-size: 28px;
        font-weight: bold;
        cursor: pointer;
        transition: color 0.3s;
    }
    
    .close:hover {
        color: #fff;
    }
    
    .modal h2 {
        color: #fff;
        margin-bottom: 20px;
        text-align: center;
        font-weight: 600;
    }
    
    .info-reserva {
        background: #212121;
        padding: 15px;
        border-radius: 10px;
        margin-bottom: 20px;
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(255, 255, 255, 0.6);
    }
    
    .info-reserva p {
        margin-bottom: 8px;
        color: #fff;
    }
    
    .duracion-reserva {
        margin-bottom: 25px;
    }
    
    .duracion-reserva label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #fff;
    }
    
    .duracion-reserva select {
        width: 100%;
        min-height: 45px;
        color: #fff;
        outline: none;
        transition: 0.35s;
        padding: 0px 15px;
        background-color: #212121;
        border-radius: 6px;
        border: 2px solid #212121;
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(255, 255, 255, 0.6);
        font-size: 1rem;
    }
    
    .duracion-reserva select:focus {
        transform: scale(1.05);
        box-shadow: 6px 6px 10px rgba(0,0,0,1),
                    1px 1px 10px rgba(255, 255, 255, 0.6),
                    inset 2px 2px 10px rgba(0,0,0,1),
                    inset -1px -1px 5px rgba(255, 255, 255, 0.6);
    }
    
    .duracion-reserva select option {
        background-color: #212121;
        color: #fff;
    }
    
    .modal-buttons {
        display: flex;
        gap: 15px;
        justify-content: center;
    }
    
    /* Loading overlay */
    .loading-overlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0,0,0,0.9);
        z-index: 2000;
        justify-content: center;
        align-items: center;
        flex-direction: column;
    }
    
    .spinner {
        border: 4px solid #333;
        border-top: 4px solid #fff;
        border-radius: 50%;
        width: 50px;
        height: 50px;
        animation: spin 1s linear infinite;
        margin-bottom: 20px;
    }
    
    .loading-overlay p {
        color: white;
        font-size: 1.2rem;
    }
    
    /* Loader CSS actualizado */
    #loader-container {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100vw;
        height: 100vh;
        background-color: rgba(33, 33, 33, 0.9);
        justify-content: center;
        align-items: center;
        z-index: 9999;
    }
    
    .loader {
        display: block;
        width: 84px;
        height: 84px;
        position: relative;
    }
    
    .loader:before,
    .loader:after {
        content: "";
        position: absolute;
        left: 50%;
        bottom: 0;
        width: 64px;
        height: 64px;
        border-radius: 50%;
        background: #FFF;
        transform: translate(-50%, -100%) scale(0);
        animation: push_401 2s infinite linear;
    }
    
    .loader:after {
        animation-delay: 1s;
    }
    
    @keyframes push_401 {
        0%, 50% {
            transform: translate(-50%, 0%) scale(1);
        }
        100% {
            transform: translate(-50%, -100%) scale(0);
        }
    }
    
    /* Animaciones */
    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }
    
    @keyframes slideIn {
        from { transform: translateY(-50px); opacity: 0; }
        to { transform: translateY(0); opacity: 1; }
    }
    
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    
    @keyframes pulse {
        0% { transform: scale(1); }
        50% { transform: scale(1.05); }
        100% { transform: scale(1); }
    }
    
    /* Responsive Design */
    @media (max-width: 768px) {
        .container {
            padding: 10px;
        }
        
        .header {
            flex-direction: column;
            gap: 15px;
            text-align: center;
        }
        
        .header h1 {
            font-size: 1.5rem;
        }
        
        .filters {
            flex-direction: column;
            gap: 15px;
        }
        
        .filter-group {
            width: 100%;
        }
        
        .filter-select {
            width: 100%;
        }
        
        .leyenda {
            flex-direction: column;
            gap: 10px;
        }
        
        .parking-map {
            padding: 10px;
            overflow-x: auto;
            min-width: 350px;
        }
        
        .parking-grid {
            min-width: 500px;
            margin: 10px;
        }
        
        .plaza {
            width: 60px;
            height: 35px;
            font-size: 0.7rem;
        }
        
        .plaza-numero {
            font-size: 0.65rem;
        }
        
        .plaza-vacia {
            width: 60px;
            height: 35px;
        }
        
        .escalera {
            right: 20px;
            bottom: 20px;
            padding: 5px;
            font-size: 0.6rem;
        }
        
        .escalera span {
            font-size: 1.5rem;
        }
        
        .plantas {
            font-size: 1.5rem;
        }
        
        .modal-content {
            margin: 10% auto;
            padding: 20px;
            width: 95%;
        }
        
        .modal-buttons {
            flex-direction: column;
        }
        
        .reserva-item {
            flex-direction: column;
            align-items: flex-start;
        }
        
        .reserva-acciones {
            width: 100%;
            justify-content: center;
        }
    }
    
    @media (max-width: 480px) {
        .parking-grid {
            min-width: 400px;
        }
        
        .plaza {
            width: 50px;
            height: 30px;
            font-size: 0.6rem;
        }
        
        .plaza-numero {
            font-size: 0.55rem;
        }
        
        .plaza-vacia {
            width: 50px;
            height: 30px;
        }
        
        .header h1 {
            font-size: 1.3rem;
        }
        
        .user-info {
            flex-direction: column;
            gap: 10px;
        }
    }
    
    /* Estados adicionales para feedback visual */
    .plaza.loading {
        animation: pulse 1s infinite;
    }
    
    .plaza.success {
        animation: pulse 0.5s ease-in-out;
        background: linear-gradient(145deg, #28a745, #1e7e34) !important;
    }
    
    .plaza.error {
        animation: pulse 0.5s ease-in-out;
        background: linear-gradient(145deg, #dc3545, #bd2130) !important;
    }
    
    /* Mejoras de accesibilidad */
    .plaza:focus {
        outline: 3px solid #fff;
        outline-offset: 2px;
    }
    
    .filter-select:focus,
    .btn-confirmar:focus,
    .btn-cancelar:focus {
        outline: 2px solid #fff;
        outline-offset: 2px;
    }
    
    /* Indicador de plaza propia */
    .plaza.mi-reserva {
        border: 3px solid #ffc107;
        animation: pulse 2s infinite;
    }
    
    .plaza.mi-reserva::after {
        content: "👤";
        position: absolute;
        top: -10px;
        right: -10px;
        background: #ffc107;
        border-radius: 50%;
        width: 20px;
        height: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 0.7rem;
    }
    </style>
</head>
<body>
    <div class="container">
        <header class="header">
            <h1>Mapa de Parking Viewnext</h1>
            <div class="user-info">
                <div class="logout-container">
                  <a href="dashboard.php" class="logout-btn">Volver</a>
                  <span class="arrow first">
                    <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                      <path d="M16.1716 10.9999L10.8076 5.63589L12.2218 4.22168L20 11.9999L12.2218 19.778L10.8076 18.3638L16.1716 12.9999H4V10.9999H16.1716Z"></path>
                    </svg>
                  </span>
                  <span class="arrow second">
                    <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                      <path d="M16.1716 10.9999L10.8076 5.63589L12.2218 4.22168L20 11.9999L12.2218 19.778L10.8076 18.3638L16.1716 12.9999H4V10.9999H16.1716Z"></path>
                    </svg>
                  </span>
                  <span class="arrow third">
                    <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                      <path d="M16.1716 10.9999L10.8076 5.63589L12.2218 4.22168L20 11.9999L12.2218 19.778L10.8076 18.3638L16.1716 12.9999H4V10.9999H16.1716Z"></path>
                    </svg>
                  </span>
                </div>
            </div>
        </header>

        <!-- Filtros -->
        <div class="filters">
            <div class="filter-group">
                <label for="fecha">Fecha:</label>
                <select id="fecha" class="filter-select">
                    <option value="hoy">Hoy</option>
                    <option value="manana">Mañana</option>
                </select>
            </div>
            
            <div class="filter-group">
                <label for="hora">Hora:</label>
                <select id="hora" class="filter-select">
                    <option value="07:00">07:00</option>
                    <option value="07:30">07:30</option>
                    <option value="08:00" selected>08:00</option>
                    <option value="08:30">08:30</option>
                    <option value="09:00">09:00</option>
                    <option value="09:30">09:30</option>
                    <option value="10:00">10:00</option>
                    <option value="10:30">10:30</option>
                    <option value="11:00">11:00</option>
                    <option value="11:30">11:30</option>
                    <option value="12:00">12:00</option>
                    <option value="12:30">12:30</option>
                    <option value="13:00">13:00</option>
                    <option value="13:30">13:30</option>
                    <option value="14:00">14:00</option>
                    <option value="14:30">14:30</option>
                    <option value="15:00">15:00</option>
                    <option value="15:30">15:30</option>
                    <option value="16:00">16:00</option>
                    <option value="16:30">16:30</option>
                    <option value="17:00">17:00</option>
                    <option value="17:30">17:30</option>
                    <option value="18:00">18:00</option>
                    <option value="18:30">18:30</option>
                    <option value="19:00">19:00</option>
                    <option value="19:30">19:30</option>
                    <option value="20:00">20:00</option>
                    <option value="20:30">20:30</option>
                    <option value="21:00">21:00</option>
                    <option value="21:30">21:30</option>
                    <option value="22:00">22:00</option>
                    <option value="22:30">22:30</option>
                    <option value="23:00">23:00</option>
                </select>
            </div>
            
        </div>

        <!-- Leyenda -->
        <div class="leyenda">
            <div class="leyenda-item">
                <div class="plaza-example disponible"></div>
                <span>Disponible</span>
            </div>
            <div class="leyenda-item">
                <div class="plaza-example ocupada"></div>
                <span>Reservada</span>
            </div>
            <div class="leyenda-item">
                <div class="plaza-example no-reservable"></div>
                <span>No reservable</span>
            </div>
        </div>

        <!-- Mapa del parking -->
        <div class="parking-map">
            <div class="parking-grid">
                <?php
                // Organizar plazas en un mapa bidimensional
                $mapa = [];
                foreach ($plazas as $plaza) {
                    $mapa[$plaza['posicion_y']][$plaza['posicion_x']] = $plaza;
                }
            
                // Generar la cuadrícula del parking
                for ($y = 1; $y <= 14; $y++) {
                    echo '<div class="fila-parking">';
                    for ($x = 1; $x <= 6; $x++) {
                        if (isset($mapa[$y][$x])) {
                            $plaza = $mapa[$y][$x];
                            $claseEstado = $plaza['reservable'] ? 'disponible' : 'no-reservable';
                            $clickable = $plaza['reservable'] ? 'clickable' : '';
            
                            echo '<div 
                                    class="plaza ' . htmlspecialchars($plaza['tipo']) . ' ' . $claseEstado . ' ' . $clickable . '"
                                    data-id="' . intval($plaza['id']) . '"
                                    data-numero="' . htmlspecialchars($plaza['numero']) . '"
                                    data-tipo="' . htmlspecialchars($plaza['tipo']) . '"
                                    data-reservable="' . intval($plaza['reservable']) . '">
                                    <span class="plaza-numero">' . htmlspecialchars($plaza['numero']) . '</span>
                                  </div>';
                        } else {
                            echo '<div class="plaza-vacia"></div>';
                        }
                    }
                    echo '</div>';
                }
                ?>
            </div>
        </div>

        <!-- Mis Reservas -->
        <div class="mis-reservas">
            <h3>Mis Reservas</h3>
            <div id="lista-reservas">
                <p>Cargando reservas...</p>
            </div>
        </div>
    </div>

    <!-- Modal de Reserva -->
    <div id="modal-reserva" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2>Confirmar Reserva</h2>
            <form id="form-reserva">
                <div class="info-reserva">
                    <p><strong>Plaza:</strong> <span id="modal-plaza"></span></p>
                    <p><strong>Fecha:</strong> <span id="modal-fecha"></span></p>
                    <p><strong>Hora:</strong> <span id="modal-hora"></span></p>
                </div>
                
                <div class="duracion-reserva">
                    <label for="duracion">Duración (horas):</label>
                    <select id="duracion" required>
                        <option value="1">1 hora</option>
                        <option value="2">2 horas</option>
                        <option value="4">4 horas</option>
                        <option value="8" selected>8 horas (jornada completa)</option>
                    </select>
                </div>

                <div class="modal-buttons">
                    <button type="button" class="btn-cancelar">Cancelar</button>
                    <button type="submit" class="btn-confirmar">Confirmar Reserva</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Overlay de pantalla completa con loader -->
    <div id="loader-container">
      <span class="loader"></span>
    </div>

    <script src="script.js"></script>
</body>
</html>