<?php
session_start();
header('Content-Type: application/json');

// Mostrar errores para depuración
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Verificar si el usuario está logueado
if (!isset($_SESSION['usuario_logueado']) || $_SESSION['usuario_logueado'] !== true) {
    echo json_encode(['success' => false, 'message' => 'Usuario no autenticado']);
    exit();
}

// Incluir conexión a base de datos
require_once 'conexion.php';

try {
    $usuario_id = $_SESSION['usuario_id'];

    // Consulta con MySQLi
    $stmt = $conexion->prepare("
        SELECT r.*, p.numero as plaza_numero, p.tipo as plaza_tipo
        FROM reservas r
        JOIN plazas p ON r.plaza_id = p.id
        WHERE r.usuario_id = ? 
        AND r.estado = 'activa'
        AND (
            r.fecha_reserva > CURDATE() OR
            (r.fecha_reserva = CURDATE() AND r.hora_fin > CURTIME())
        )
        ORDER BY r.fecha_reserva ASC, r.hora_inicio ASC
    ");

    $stmt->bind_param("i", $usuario_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $reservas_formateadas = [];
    while ($reserva = $result->fetch_assoc()) {
        $reservas_formateadas[] = [
            'id' => (int)$reserva['id'],
            'plaza_id' => (int)$reserva['plaza_id'],
            'plaza_numero' => $reserva['plaza_numero'],
            'plaza_tipo' => $reserva['plaza_tipo'],
            'fecha_reserva' => $reserva['fecha_reserva'],
            'hora_inicio' => $reserva['hora_inicio'],
            'hora_fin' => $reserva['hora_fin'],
            'fecha_creacion' => $reserva['fecha_creacion']
        ];
    }

    echo json_encode([
        'success' => true,
        'reservas' => $reservas_formateadas
    ]);

} catch (Exception $e) {
    error_log("Error en mis_reservas.php: " . $e->getMessage());
    echo json_encode([
        'success' => false, 
        'message' => $e->getMessage()
    ]);
}
?>
