<?php
session_start();

require_once 'conexion.php';  // Aquí tienes $conexion como objeto mysqli

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: login_register.html');
    exit();
}

$email = trim($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';

if (empty($email) || empty($password)) {
    header('Location: login_register.html?error=missing_fields');
    exit();
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    header('Location: login_register.html?error=login_failed');
    exit();
}

if (substr($email, -strlen('@viewnext.com')) !== '@viewnext.com') {
    header('Location: login_register.html?error=login_failed');
    exit();
}

$stmt = $conexion->prepare("SELECT id, nombre, apellidos, email, matricula1, matricula2, password FROM usuarios WHERE email = ?");
if (!$stmt) {
    error_log("Error en prepare: " . $conexion->error);
    header('Location: login_register.html?error=database_error');
    exit();
}

$stmt->bind_param('s', $email);
$stmt->execute();
$result = $stmt->get_result();
$usuario = $result->fetch_assoc();

if ($usuario && password_verify($password, $usuario['password'])) {
    $_SESSION['usuario_id'] = $usuario['id'];
    $_SESSION['usuario_nombre'] = $usuario['nombre'];
    $_SESSION['usuario_apellidos'] = $usuario['apellidos'];
    $_SESSION['usuario_email'] = $usuario['email'];
    $_SESSION['usuario_matricula1'] = $usuario['matricula1'];
    $_SESSION['usuario_matricula2'] = $usuario['matricula2'];
    $_SESSION['usuario_logueado'] = true;
    $_SESSION['login_time'] = time();

    session_regenerate_id(true);

    // Actualizar último acceso (opcional)
    $stmt_update = $conexion->prepare("UPDATE usuarios SET ultimo_acceso = NOW() WHERE id = ?");
    if ($stmt_update) {
        $stmt_update->bind_param('i', $usuario['id']);
        $stmt_update->execute();
        $stmt_update->close();
    }

    $stmt->close();
    header('Location: dashboard.php');
    exit();
} else {
    $stmt->close();
    header('Location: login_register.html?error=login_failed');
    exit();
}
?>