<?php
session_start();

require_once 'conexion.php'; // $conexion es mysqli

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: login_register.html');
    exit();
}

$nombre = trim($_POST['nombre'] ?? '');
$apellidos = trim($_POST['apellidos'] ?? '');
$email = trim($_POST['email'] ?? '');
$matricula1 = trim($_POST['matricula1'] ?? '');
$matricula2 = trim($_POST['matricula2'] ?? '');
$password = $_POST['password'] ?? '';
$confirm_password = $_POST['confirm_password'] ?? '';

$errores = [];

if (empty($nombre)) $errores[] = 'El nombre es obligatorio';
if (empty($apellidos)) $errores[] = 'Los apellidos son obligatorios';

if (empty($email)) {
    $errores[] = 'El email es obligatorio';
} elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $errores[] = 'El formato del email no es válido';
} elseif (substr($email, -strlen('@viewnext.com')) !== '@viewnext.com') {
    header('Location: login_register.html?error=invalid_domain');
    exit();
}

if (empty($matricula1)) $errores[] = 'La matrícula 1 es obligatoria';

if (empty($password)) {
    $errores[] = 'La contraseña es obligatoria';
} elseif (strlen($password) < 6) {
    $errores[] = 'La contraseña debe tener al menos 6 caracteres';
}

if (empty($confirm_password)) {
    $errores[] = 'Debe confirmar la contraseña';
} elseif ($password !== $confirm_password) {
    header('Location: login_register.html?error=password_mismatch');
    exit();
}

if (!empty($errores)) {
    // Podrías pasar errores detallados, pero para simplicidad:
    header('Location: login_register.html?error=missing_fields');
    exit();
}

// Verificar si email existe
$stmt = $conexion->prepare("SELECT id FROM usuarios WHERE email = ?");
if (!$stmt) {
    error_log("Error en prepare (select email): " . $conexion->error);
    header('Location: login_register.html?error=database_error');
    exit();
}
$stmt->bind_param('s', $email);
$stmt->execute();
$stmt->store_result();

if ($stmt->num_rows > 0) {
    $stmt->close();
    header('Location: login_register.html?error=email_exists');
    exit();
}
$stmt->close();

$password_hash = password_hash($password, PASSWORD_DEFAULT);

// Insertar usuario
$stmt = $conexion->prepare("INSERT INTO usuarios (nombre, apellidos, email, matricula1, matricula2, password) VALUES (?, ?, ?, ?, ?, ?)");
if (!$stmt) {
    error_log("Error en prepare (insert): " . $conexion->error);
    header('Location: login_register.html?error=database_error');
    exit();
}
$stmt->bind_param('ssssss', $nombre, $apellidos, $email, $matricula1, $matricula2, $password_hash);

if ($stmt->execute()) {
    $stmt->close();
    header('Location: login_register.html?success=registered');
    exit();
} else {
    error_log("Error en execute (insert): " . $stmt->error);
    $stmt->close();
    header('Location: login_register.html?error=database_error');
    exit();
}